#!/bin/sh


#################################################################################
# Copyright 2008 YSoft Ltd.                                                     #
# All Rights Reserved                                                           #
#################################################################################

skip=279			# lines +1

if [ "$1" = "-u" -o "$1" = "--uninstall" ]; then
  cat <<END_UNINST

Welcome to Ysoft SafeQ Client for linux instalation

You selected to uninstall SafeQ Client for linux

Do you agree [y/n]?
END_UNINST

  read USER_INPUT
  if [ "$USER_INPUT" = "y" -o "$USER_INPUT" = "Y" -o \
  	  "$USER_INPUT" = "yes" -o "$USER_INPUT" = "Yes" -o "$USER_INPUT" = "YES" ]; then
	  echo "OK, lets continue."
  	  else
	  echo "OK, bye...."
	  exit 1
  fi;

  if [ ! "`whoami`" = "root" ]; then
	echo "Only system administrator - root could uninstall this package, do you wants to continue?"
	read USER_INPUT
	if [ "$USER_INPUT" = "y" -o "$USER_INPUT" = "Y" -o \
	 "$USER_INPUT" = "yes" -o "$USER_INPUT" = "Yes" -o "$USER_INPUT" = "YES" ]; then
	  echo "OK, lets try it"
	else
	  echo "OK, exiting...."
	  exit 1
    fi;
  fi;
  rm -f /etc/xdg/autostart/sqport.desktop
  rm -f /etc/sqclient.conf
  rm -f /etc/dbus-1/system.d/sqport.conf
  rm -f /etc/logrotate.d/sqport
  rm -f /usr/local/share/pixmaps/sqport/ysoft_logo.ico
  rm -f /usr/local/share/pixmaps/sqport/ysoft_logo.png
  rm -f /usr/local/share/pixmaps/sqport/ysoft_logo.gif
  rm -f /usr/local/bin/sqport_gui
  rm -f /usr/local/bin/sqport_gui.pyc
  rm -f /usr/share/applications/sqport.desktop
  rm -f /usr/share/autostart/sqport.desktop
  rm -f /usr/lib/cups/backend/sqport
  rm -f /usr/lib/cups/backend/sqport.pyc
  rm -f /var/log/cups/sqclient_backend.log
  echo "All files removed"

  exit 0
fi;		#end uninstall


cat <<END_INTRO | more

Welcome to Ysoft SafeQ Client for linux instalation

Before instalation you have to agree the license terms

STANDARD LICENSE TERMS AND CONDITIONS
Y SOFT, s.r.o.
 
The License terms and conditions specified hereunder are binding upon all users of all SW developed, or in any other manner delivered, by the company Y Soft, s.r.o., registered in the Commercial Register maintained by the Municipal Court in Prague under Section C, Entry No. 78957, ID No.: 26197740, with its registered office at Prague 3, U Kněžské louky 2151/18, Postcode: 13000 (hereinafter referred to as the ”Company“), irrespective of the method of delivery of the SW.
 
Art. I. - Definition
 
1.1     Licensee: Person who, on the basis of ordering a specific License to defined modules or programs of the Company's SW, being granted a License Certificate, and paying a License fee, is afforded the right to use the Company's SW to the extent and for the time specified in the License Certificate issued by the Company.
 
1.2     Company's SW: All SW that is developed and provided by the Company or, as the case may be, all SW to which the Company may, on the basis of any other right, provide Licenses to potential Licensees.
 
1.3     Provided SW: SW whose use was requested by the Licensee, and whose use by the Licensee has subsequently been permitted by the Company to an extent compliant with the License Certificate.
 
1.4     License Certificate: A certificate issued by the Company to a specific Licensee and with respect to particular Provided SW, on the basis of which the Licensee has the right to use the Provided SW to an extent corresponding with the Company's valid License Terms and Conditions that are valid at the time of the issue of the License Certificate. The License Certificate, in particular, contains the date of the granting of the License, the period of time for which the License is granted, the individual modules and programs for which the usage right is granted to the Licensee, as well as reference to the current version of License Terms and Conditions stating the extent of the License granted to the Licensee, and, if applicable, details of persons on whose behalf services may be established by the Licensee through the use of the Provided SW.
 
1.5     Authorised Partner of the Company: A company that has concluded a framework agreement with the Company under which the training of the technical staff of such Authorised Partner of the Company shall be provided for the purpose of implementing and maintaining the Company's SW.
 
1.6     License fees: Fees that the Licensee shall be obliged to pay to the Company directly or indirectly (through the Authorised Partner) for the use of the Provided SW. License fees shall be paid in an amount based on the customer price list that is valid on the date of issue of the License Certificate for the Provided SW, unless another amount for the License fee is otherwise agreed upon with the specific Licensee and confirmed in writing in the License Certificate.
 
Art. II. - Use of SW
 
2.1     Subject of the License
 
Based on the issue of the License Certificate, the Licensee is granted a non-exclusive right to use the Provided SW in the limited scope of its own business activities (a) to the extent stated in the License Certificate, (b) for the period stated in the License Certificate, and (c) under the terms and conditions stated in the currently valid License Terms and Conditions of YSOFT. If the License is granted for the purpose of providing services to the third persons through the use of the Provided SW (outsourcing), the Provided SW may only be used for provision of services to the person listed in the License Certificate.
 
2.2     Right to Use the Provided SW
 
The Company represents that it is exclusively authorised to grant a License to the Provided SW. Both contracting parties acknowledge that the Licensee does not, and shall not, obtain the ownership right hereunder to the Provided SW and that the Licensee shall only have the rights to the Provided SW that are specified in the currently valid License Terms and Conditions of YSOFT.
 
2.3     Limited Validity of the License
 
Until the Company has been paid the full fee on behalf of the Licensee for the granting of licensing rights (i.e. the License fee), the Licensee shall only have a temporary right to use the Provided SW, and the Company may, at its sole discretion, ensure the temporary nature of the operation of the Provided SW, by enforcing appropriate technical measures including the activation of a disabling access code within the Provided SW etc. The Company is also entitled to revoke the License in the event that the License fee for the use of the Provided SW is  not paid for any reason whatsoever to the bank account of the Company within the due period and in the full amount - In such case, the Licensee shall be obliged: to return any documentation related to the  Provided SW as well as any media containing installation files; to evidence the destruction of any back-up installations or installation files for the Provided SW; not to use the Provided SW in any respect; and to enable the representatives of the Company to inspect the fulfilment of these obligations.
 
2.4     Non-transferability of the Granted License
 
The License to use the Provided SW shall be granted to the Licensee solely for its internal business use (except where the License permits the provision of services through the Provided SW to other persons, in which case the Licensee may proceed in accordance with the content of such License). The Licensee may not, either for or without consideration, return service, or payment, in any way further assign the rights and duties arising from the granted License, or loan, rent, sub-license, or in any other manner transfer the Provided SW, or use the same as collateral or as security with respect to the Licensee's or any other person's obligations.
 
Where the License is granted for the purpose of providing services to other persons through the Provided SW (outsourcing), the Provided SW may only be used for the provision of services to another person whose identity has been reported in advance to and subsequently confirmed by the Company in the License Certificate authorising the use of the Provided SW.
 
2.5     Changes to the License
 
The Licensee may not use the Company's SW in a scope exceeding the License granted to it (e.g. by involving a higher number of users, terminals, or servers etc.), or use the License in a manner other than the one determined hereunder (e.g. as a terminal License for servers etc.), without the prior written consent of the Company (thereby extending the License Certificate) and without paying additional fees based on the Company's valid price list. Should the Licensee use any of the Company's SW in a manner other than that permitted under the License Terms and Conditions of YSOFT, or in a scope other than that permitted under the License Terms and Conditions of YSOFT, without the prior written consent of the Company, the Licensee shall pay the Company a contractual penalty amounting to twice the price of the Company's SW License which the Licensee would have needed to acquire to use the Company's SW to the extent and for the purpose that it in fact uses the Company's SW. Payment of the stated contractual penalty shall not affect the Company's right to terminate the validity of any License granted to the Licensee without entitling the Licensee to receive any settlement or reimbursement of any previously paid price for the License.
 
2.6     Copying the Provided SW
 
The Licensee is authorised to make one back-up copy of the installation disks/files for the Provided SW. The Licensee may not use the back-up copy of the Provided SW within the scope of its regular activities, or for training or demonstration purposes. The Licensee agrees to mark the back-up copy with the relevant number of the License, as well as with a statement regarding the Company's intellectual property rights and the fact that this is strictly a back-up copy, and with identification labels containing the details of the period for which the License shall be granted. With the exception of the back-up copy, the Licensee may not make copies of the Provided SW for any purpose.
 
2.7     Altering the Provided SW
 
The Licensee may not conduct reverse engineering, decompile, or disassemble the Provided SW or any other SW of the Company, and it may not reconstitute the source code of the Provided SW or any other SW of the Company, except in cases where such a restriction is not permitted under governing law.
 
2.8     Infringement of Rights related to the Provided SW
 
The Licensee undertakes to promptly inform the Company of any case of which it becomes aware regarding the infringement of the Company's rights in relation to the Company's SW, and in particular, the Provided SW, and to provide the Company with adequate assistance in establishing the Company's claim regarding the infringement of the  rights to the Company's SW.
 
2.9     Warranties
 
The Company warrants that the Provided SW will operate in accordance with the specifications stated in the technical documentation materials that are included on its provision (hereinafter referred as to the “Documentation”), provided that the SW's operation does not conflict with any other applications operated by the Licensee, and it is used with compatible HW and technical equipment for which the Provided SW is determined/designed, and is duly installed by a person trained for this purpose (i.e. by a technician of the Company or of an Authorised Partner of the Company), and is duly used in accordance with the specification and purpose of the Provided SW. Since the Provided SW is an up-to-date developed product of the computer technology of its type, and it is currently not possible to test and monitor all potential uses of this SW, the Licensee hereby acknowledges that in view of the surrounding variability, and the continuous development of technical equipment through which the Company's SW is operated and with which it coexists, the Company cannot warrant that the Provided SW is unconditionally error-free. Nevertheless, the Company undertakes that for a period of two (2) years following the delivery of the Provided SW, it will make all possible efforts to repair any detected errors, anomalies, or repeated errors that are reported to the Company by the Licensee, and to remedy the same through, at its sole discretion and according to the severity of the error, a “hot fix” (one-off repair) or general repair (service pack), as provided to all users of the relevant version of the Company's SW. The Company hereby also reserves the right to resolve the warranty claim by granting a License to a later version of the Company's SW with relevant functionality. For the period of the provided warranty, support for the relevant version of the Provided SW shall also be made available via the Authorised Partners of the Company.
 
The Company hereby reserves the right to release repair packs from time to time with respect to any of the Company's SW for the purpose of resolving defects, anomalies, or the limited functionality of any of the Company's SW. Should such repair packs not be promptly installed by the Licensee, the Licensee shall lose all rights arising from the provided warranty.
 
The Licensee shall also not retain any rights arising from the warranty if the Licensee does not provide the Authorised Partner of the Company or the Company's representative with the appropriate assistance required to determine the causes and the effects of the claimed defect, as well as appropriate assistance required for its remedy.
 
Unless the Licensee purchases additional License services or additional Licenses according to the Company's valid price list, and on this basis acquires the right to use additional versions of the Provided SW that are currently being developed, the Licensee shall not be authorised to use other versions of the Provided SW on the basis of the granted License. (This shall not exclude the possibility of the Licensee using up-dates of its utilised versions that are released by the Company or service packs etc.).
 
The Licensee is obliged to lodge its warranty claim (i.e. claim for the resolution of a defect in the Provided SW) through the Authorised Partner of the Company which delivered or, as the case may be, which implemented the Provided SW.
 
2.10    Obligations arising from the Operation of the Provided SW
 
The Provided SW shall be operated and used only for the Licensee's activities, and under the Licensee's supervision and at its liability. The Licensee shall be solely responsible for (a) assessing and evaluating the effectiveness of the Provided SW for its requirements; (b) ascertaining that the Provided SW is appropriately used with respect to its personnel and computer resources, (c) ensuring that all computers programs and hardware used in conjunction with the Provided SW are in particular free from any defects that adversely affect the functionality and operation of the Provided SW, (d) establishing adequate operating supervision and procedures within the organisation of the Licensee, and (e) for preparing or implementing troubleshooting plans including replacement and safeguarding measures (covering regular and adequate data back-ups and the redundancy of critical systems).
 
Where licenses enable the provision of services using the Provided SW to other parties, or the usage of the Provided SW for other parties by the Licensee (outsourcing), the Licensee may use the Provided SW in compliance with the relevant License for provision of services to other parties provided that the Licensee retains full liability for (a) assessing and evaluating the effectiveness of the Provided SW with respect to the assumed requirements, (b) ascertaining that the Provided SW is appropriately used with respect to its personnel and computer resources and, (c) ensuring that all computer programs and hardware used in conjunction with the Provided SW are in particular free from any defects that adversely affect the functionality and operation of the Provided SW, (d) establishing adequate operating supervision and procedures within the organisation where the Provided SW is used, and (e) preparing or implementing troubleshooting plans including replacement and safeguarding measures (covering regular and adequate data back-up and the redundancy of critical systems).
 
2.11    Liability
 
The Company shall not be liable for any direct or indirect damage (including, but not limited to, damage in the form of business losses, tax penalties, or other debts to administrative authorities, loss of profit, damage to business relations, and loss or corruption of data) arising on the side of the Licensee or other parties to which the Licensee provides its services as a result of the use of the SW in accordance with the content of a concrete license, or arising from the use of the Provided SW. This shall also apply in cases where the Company has been notified in advance of the possibility of such damage arising. In no case shall the Company's liability towards the Licensee or any third parties arising from the use of the Company's SW, or any amount of damages, exceed the License fee paid by the Licensee for use of the Provided SW, and this liability shall cover all of the Licensee's claims for damages against the Company arising from the granting of the License to the Provided SW and its use by the Licensee. The Company shall also not be liable for any damage caused by (i) the activities of third parties, or by the services which they provide, (ii) the use of other SW, or (iii) the neglected maintenance of the Provided SW (e.g. non-installation of available service packs etc.), including any and all damage caused by other delivered SW or services provided by Authorised Partners of the Company.
 
 
Y Soft, s.r.o.
 
Effective date of this version of the License terms and conditions:     1st July 2006
Issue date of this version of the License terms and conditions: 1st July 2006


Do you agree [y/n]?
END_INTRO
read USER_INPUT
if [ "$USER_INPUT" = "y" -o "$USER_INPUT" = "Y" -o \
	 "$USER_INPUT" = "yes" -o "$USER_INPUT" = "Yes" -o "$USER_INPUT" = "YES" ]; then
	echo "OK, lets continue."
	else
	echo "You must reply with 'y', exiting without instalation...."
	exit 1
fi;

if [ ! "`whoami`" = "root" ]; then
  echo "Only system administrator - root could install this package, do you wants to continue?"
  read USER_INPUT
  if [ "$USER_INPUT" = "y" -o "$USER_INPUT" = "Y" -o \
	 "$USER_INPUT" = "yes" -o "$USER_INPUT" = "Yes" -o "$USER_INPUT" = "YES" ]; then
	echo "OK, lets try it"
  else
	echo "OK, exiting without instalation...."
	exit 1
  fi;
fi;

cat > /tmp/check_modules.py <<CHECK_MODULES
#!/usr/bin/env python

try:
    import sys
except ImportError:
    print ("Fatal error, your python instalation is corrupted")

print ("Checking for required python modules.")
try:
    print ("Checking for...","string","...")
    import string
    print ("OK")

    print ("Checking for...","gtk","...")
    import pygtk
    pygtk.require('2.0')
    import gtk
    print ("OK")

    print ("Checking for...","gobject","...")
    import gobject
    print ("OK")

    print ("Checking for...","dbus","...")
    import dbus
    import dbus.service
    import dbus.mainloop.glib
    print ("OK")

    print ("Checking for...","os","...")
    import os
    import os.path
    print ("OK")

    print ("Checking for...","socket","...")
    import socket
    print ("OK")

    print ("Checking for...","ConfigParser","...")
    import ConfigParser
    print ("OK")

except ImportError:
    print ("Fatal error, required pyton module missing")
    print (sys.exc_info())
    sys.exit(1)

CHECK_MODULES

chmod +x /tmp/check_modules.py

/tmp/check_modules.py

if [ $? -eq 0 ]; then 
  echo "All required python packages ok"
else
  echo "Install required python modules and run instalation again"
  exit 1
fi;

rm -f /tmp/check_modules.py

UnTAR() {
    tar -C / -pxz
}

echo "Unpacking files"

if ( ! tail -n +$skip $0 | UnTAR  ); then
  echo "Error extractin files"
  exit 1;
fi;

echo "Instalation done"

cat <<END_TAIL
---------------------------------------------------------------------

CONFIGURATION:
Don't forget to set up SafeQ Client configuration file: /etc/sqclient.conf

Printer which have to use SafeQ Client must have destination URL:  
sqport://server_ip/printer_queue

LOGS:
There are two log files, one for backend and one for gui.
To get backend logs just simply create file /var/log/cups/sqclient_backend.log
(this is defaultly created for you)
Gui logs are configured via main configuration file.

FIRST TO DO:
To get SafeQ port functional you have to reboot your machine
(or reload Dbus service, and restart X session)

---------------------------------------------------------------------
(C) Ysoft Ltd. 2008

END_TAIL

/etc/init.d/dbus force-reload

exit 0

END_SCRIPT
 K sqclient_linux-1.0-python3_1.tar <KoGz=!)ٲT<"9+4IV8tqL$'6l9r	C r1? @nI Akg8CI^a6aWWU߫GUOgsԯ<\/L<Շ+g
S3sfgO57\~ga['4_lNSցI-C榦y?]O{Y*lɱw(๙N/́MhtafǤo[jX64vė|8.XvpQӬr|ǪX<2I,kհv*o
@+|Y) iQ0L4PTf
u;ۙ	;\}*<nx<!p5u/W27Ju`u^XHec*B@ 8vAw+pwংSOk7FVl⽵"/]|z?Xk+
m}a,KYu^rR;0 JA͋îݛW
M_im4C;&m-"S5MNֿGfcW"39s&WCF;ksNس)}ߩs$LϴnP8岔2/඾Ҋv1-pڪQ#8mɩVfa#h	0J@Av*7y͵.k#QZ:Qm[vvz9-V-ۨ,Oh[X[UpV zLvv
WjQՠ =g:LVک/n %@츖x!%?0u|F<8<?ys[?S=zyB_^Ӱ*uTk]FV-k{ondR\P:gq5ߣ 'fW{:
x%h4I3>xA<_`eߜv\!}\nyk/O.>䋁Ǘ6|.W\񛻾_fݳ[!iGNY7o~}W|izcr[wlK͝CCN7䨤qBsϰ[́t8nb*MlfRqq"R
˖o@=t W"U$ct+w(Nݶ;LjM9'Yy'	7Q_[*:p2::6s\BM5\YE99^_~v꬟lbxO
sŕmل=9^C?UM77K??+_c73[:z) ^Vw[Z'NdY:$ׁEWKofٹ3\k}_}ߟ7z ~޿	
01؞LP6ؓTtfO}W>fO7-\`ir3Tgf7@C52f{lo 9q#s*/)!_Ed"DA$HB'`
{aK)
tA ,±S8]cM+T&T槚0Ӿ͸!
ǁ0nRE
*ϰnCNIê<Ԉg&z(_
 kh{Ua;qiWx8\vS
Kx	SG|jTX~' &=H#De'͡eTg1GЏ`I3>u0s<ۺ0#$QeT:hJ)
+*	~WVqT
*I1OIw)-2Ġt'!8 _Uèx">Z}J?+bfJ')-4*SFC;.eXAcq=4.*?{(m.A !{GǱ@4 {&|F6T 6ø4p4sV
ٕ?dlIH&CB2XfGh`.(왂
hOgQW-{_B=D5P?A@9AX!Q^0r8gۻIKCh4nQI_`!܅hA9Յƣ}=ZK 
r
2 {ÒҤҤQa +K
hAiCC-X
1JD# L"b<s9`惝0!aF6${\cEbuRťNX-X@'Nܐ@$w4>A]Y
w x?*Z.pqֿMD;|Bd58J
dN|':6⎵,\Gci!yk`sBn
~֎6p;ܚ:}J<)*w潭	D;vPzYܣGϋ!rQY'tW<
Oҷ axzr0/Wq+` @SlHX	שǶEoH8?_t@4hFx8X\
eoR88\eSLbU#+]Cmbu*#l$>[kK?~Kab #䥻r݇H*'i6X	ƶsАEz:tO
a0N\l
_W@H$m4lHmJw;$BBȂpݐ$wC[t8Ua[@VS1TQ9M#.DYaA^`a^eB-WR.ej!TFqeg}gA%9`TT` s)9W'z"k`tDU*X<)mqD~&4DKyP2WtY>jjFɨ}M@O䁔`ʗ{e ]XI!yS'0PɄbL	3UzOmNazCc&Si</cՐ`5$'3Ug>*)Qڒhq)Q;e>js&3-
hW sFҕ| @ӔH"?BQlM!E̚D	)=x2'PⰯ}YN剔	>C^V1S)Ж%1;ݵF؇lSt &*Mb(nlmSu~a"l*-C)Ju^ڸ24Y$Ĵr,4E5E2P5~.w	zlp|7|3! qLw_wks6fTfCnŗ=LNE-5$RUlhܤ-XSW~M;Cu%2X
Q`"eYeWGT9ߨ]8o&>P;Wl8Mν+GDa8(2WW׉"C¿-L.cجB*3R$! tK"mQnP*[8FEG@*W.- UE\g%T@	ĳRX08o,[qxߵ]yT.TY!Q9c\t(J$vh>##⚮0 t@q#[=q2z`ѐGCJ:ߏ!"(lN
GO?5)G q"(1[J0m`4t
s7פ
ƞmw_=ۑpڷ(厱6s\Fw=8o/39G'S#l-^R.&f0/$2OIIm4NMvM<1hmBM]ǚxLˍpaG$D1~"]J61O^cU=o"~=]?nܭ/3[9A!r#_QNBW;/;]x:ϛND
:
+'*͛!.'\?HGҋO q>: ;Sο y	ynti9)<v?S?AC	M|+j0Z!>j1	/S9x}C-'?DD6Fͮϓ23(ّm"{v_"I/32g٧^IfzQc"mha>}y
ĵ:Ͷ7smMՍ͉O(D˶ed6an2{e+C{e-͛B>#A-LۡQ褘#
|w
{4
lEcCot
mؕ:{45?BH"xl$]Qw4_&YE0XF`K/fP
 e5%@?|}dK
d'_d0"AxApO0j
;P}/:Pt-EgOܢsޢ:ȣVk"~o~?,nC/4pm H*+YE
8~en	2UN5ZDpPnV+Q
j.
p NZ0۩Or\*Rnkrv<@K#-q[RKo Y	xը|E=K~I~:@q _FY¾7yZw8\ PBS6[2&p6T~c{Ma'787K;lK(	CФ82M-XjVj5#*lm&mDwp1R7	Mw@ĠJOwYˎq HH('D9F#n02-XW>JZP
 &P3 eeIH籬\)%\^DM'|	TwmrZܺٔ=twO=㙋.a
CG-Vo+;sO	c^	A].%2cjw+-b&n^nnm~ѴJx`4MS1%~Jh&"ߞJZr
!(b3<*D^Ы9dw $/FsR1:rG"UdbWr\G!%MuH:XAKwgo5(xLا~e~.+cPS5wסK*իУ?R.)ʐ5u#Tz;WSd[އQqS)
sgԏB
#^z
0RJjF+j}6FQc_b{6-M%IBeM\T7V-r)IYRPJ}ET*]?y|^Y{99sPG8fp~U2H^+Q"w?E)ӡ#dp748Rsc
4cmEiWvf̬
j#O_{
íNWpwl0V_ ,
WZ($ RSZc_ƨiiqQ>ocW^]7N2r2Fyhn|(P__;2}EC |U+LE&sw3%pk"_452i1Ā
!wMt$Zl`6`(q~Z}UFp
6d/k3IQ|eZ
̱rztlB5U~Co	!snJ:YLhNe;
s5~KR}Wwj|BL񏑻.8?xN'VEH5
,kV_<.ADPytZO)~&s/wf6	4,]fnT,O(ͳ<_i<0:S=
UK#,ekb,Qtn8&U?"%55o"[:hHjyPItUw<^v^Z<TvcJ輙qU.ex=!-ąlWj!-?1y;TK*+O5Z\;)'BOX_ Z"Oٶ'7EoI-ݟܕ\r5rrɯeKr-Ƽmک?YNbS]*=^9j>sKDwl,}+ajD7w+!պPEFEW\=}9-F?dպE3VyI#wƸMjKq{XU2_`Ҽ]ka8Soԙ%6i>
o_|u@gܾYj邱ݥ:/2wF]~dzDty2׺ΑuQuau<xcE%މ
ZsU$sUOK-#;&hW{("]+>T4NiF/:@Iu2grYr.<]~Ǐch}_u@ZD/0Jubm+*Ϋ,MT\qq%B-03]04r߲aѺL5gmM15[`Hi2[zINٿIm3meZ{-RڻU!Ӫs$63yԠg4TsEtcAjh_CrB/'xVڣY(tI&]pWQxQ\V<Ko$GjȄR
uhN}MWs$mc{Ɲۏ#MlB2\oՑGV-	%IIrdm:ZJR(׭_0}=:A\egn"(ʓK>Gp(uiH.ݚvkbֵ?xi2RYbCWg_G.
omy$R?O#1rA=JD$m(}Bދni~"DrfШn>$ZhxR<_?n[>MNRٽyAWݓ[i4:%OO廼(I6*KD$? ɑ$cG),Hdj߸xi"VDéc7_f:?įY-ze)F+>txJ,ρ,jVH.<E{4D_7QwSYlD
m{z䮔^B9pFe;)lixz9rI%v .\itE&0.*4XC֤(Bb}ʮ!lVZQ_cnZ4jHtI>! <dY$?'5Z6ֱ:ۂ5)<]]0		VfAؗ--R>j-ըob=;h֧ips4R)z\_wk&^#}?(6Y/_v[*d7>6Xf0CEʫZl@"Pҫ,&eY{M<Ó}C4YؽwԬ0iN~x?]PokRPBnY2k+]z03WYMNQHq=|ʞO[para_ XnE5jMEUHmyM|;-MLqҜ_ceo.K| Ek\T%;"i椸BFqKuigt%ȟ3sT/Z5uhZcQ*1MZpZdsJ۩D˧&<'Qa3\-Ν~ByD&v#[@-JEpb[>DMS۳J*~ƗIlːC2PHp}EIwrW|*JSOpAӑkDSE=[v*!T>
#Irl\)tojR7l1FZWZzm[&c܈I1=r[Q`R{U{gz-NCMxG.BCκ~YvJ[d
j!޽MLKDR/r+/<;0y	iK0ވqi_2P*}f%#c1fsj>2Eڹ<|s
exCН!q;ׄ}NOM6=Y\'Gབྷ%1NC4hDcMJcǬSxT4 FNV4):Ǳ),H{Cj7y)%5M'!ŒoJV""V8
'$0{QX	N{5:ͧsx%ұ&!$A7Ts^))ÖjmvREIZ	;.9-M+bv]WoFy%~7.dPn$扒
$G3vQ|[VP3|!B
^*mq6lQ] ImWX2M 27XWUQi})WdT*XtN,v`L%q;LYY)
fuc|E{>_SKKW[5??2tv:S\!qp+\
WQ ;iG_
Gփp{-,Ma} =l,8;p]Nw-'0 Gjh%ļۑ
b~51O=dC{?Cl)އ 6N1	U5$?~Ț$ّu2;OֈbC{
 d^eؾ{qyQ_aC6Q˛ s'v}%t+~	vx.`K,fyYmBFn؆wCg6txYT`nV#ܟN춤U:l;<׸1nGňؙe[ @w@d{Ȇ_88A#?ܩ{eCچe>
 \QkKi|euZO\mIzRuPl}1r"1X}wĺ9F_a9ȯrE|9>aKaOk
"2 + /\|`v_b/ctc*8҉D75goْ^a/Az5e>.#m-5m\sG:x|tځ=e\!BdG]ĥWٳ8] w=W	ŖBYbp+\
W2`@&bX>ј8Fʷp2KC<LM@XwB֍4օ$kF>XCTp*|!hA#`4JPtNBkP*&@0Ʈ} f.SKw|co9_^
ϗOfq~0D?.2B(:;GEdӚ{<!tX;4: x톆doaOS<K dzd=L`qk3	`@+̫Q@La0At0y6'!3pa'[\,^.wW!D}ȅi~16O5b_'	!g}L
ENr	NG!zZֻ@|LB0;1LmA,6XP{6bLa_g0ϐ0L
gp㤅#0t'{#aW.LYT,X$Q'?tC}!!90幧<	E
aLdes(SKa4^''IʝƇgf
C̼`>m'[.}Jt?+0+_~[r5z/-d3v~m$ YIQdHuPߛɹ"d^b" A
M"aSdٮ:#H@n7#zVFc8ncoZ\V&qsU.xw
R!^*;B E_,3g PԢcnPőBgp*Vw1)kź㾶&ucyoi!l|h
ʠ, XA: 7כi&w̛{ĺD{70^:Ԍ-㊎Kpm|!}Kz[+-&i\n"Od䉡ǆ_.ZchF=RMT9ElK's1T5 ERk#AǄ#@x)kd\^<k%X~r }Fdi d(-d5H ˂ooޯ5Z5&cXuRdB?0yf	D-?WWW㒺~BOH?=<Tq]{t@\B\@n|k]F.5d+<g ,faYyqYM7'X-.6c?3A,.;uǟrр[S霙-V}4\\Pq6啪j<:A[e(Иt*w5)c~{	#Az{(`a
(ǶA&_f(xz/}muĂ`\6n~^h'pڏ?+ y}
\Ox(zˑmt$?hMp$v!4WS<fȝ7{ս"|~u
y'ߥ9piլDYQ'DCز}%&,][kTbRB^BB[XN-	n/ v)XoU}oISh7E~'t(\|&`#rMx/f
L6:
縓ƁCpc*!_$Lj_qb{/"W.%QI
,q`)@?6hhulbURBO#NT-v]4(4Rzė&+sΝe¡%G1iAL |<0N/ʿɥ88ZeasB;i1F@vzOko$14u hnL>σ/D"H$D"H$D"H$D"H$D"n   